﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.PhotoGallery;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class PhotoGalleryManagementController : BaseController
    {
        public ActionResult Index()
        {
            PhotoGalleryModel model = new PhotoGalleryModel();
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.PhotoGalleries.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower()))).Select(p => new PhotoGalleryModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title,
                                                         ImagesNo = p.PhotoGalleryItems.Count()
                                                     });
            var count = query.Count();
            List<PhotoGalleryModel> list = new List<PhotoGalleryModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }
        public ActionResult AddEdit(int? id)
        {
            PhotoGalleryModel model = new PhotoGalleryModel();
            AdminSetting(model);
            if (id.HasValue)
            {
                PhotoGallery obj = context.PhotoGalleries.Where(p => p.Id == id).FirstOrDefault();
                model.Id = obj.Id;
                model.Title = obj.Title;
                model.TitleAr = obj.TitleAr;
                model.Featured = obj.Featured;
                model.Photo = obj.Photo;
                if (obj.PhotoGalleryItems.Count() > 0)
                    model.Items = obj.PhotoGalleryItems.Select(a => new Item
                    {
                        Id = a.Id,
                        Description = a.Description,
                        DescriptionAr = a.DescriptionAr,
                        Photo = a.Image,

                    });
            }
            return View(model);
        }
        [HttpPost]
        public ActionResult AddEditAr(PhotoGalleryModel model)
        {
            PhotoGallery obj = context.PhotoGalleries.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleAr = model.TitleAr;



            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEdit(PhotoGalleryModel model)
        {
            if (ModelState.IsValid)
            {

                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.Photo))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);
                       
                        return View(model);
                    }

                }
                PhotoGallery obj = null;
                var path = "";
                if (model.Id > 0)
                {
                    obj = context.PhotoGalleries.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new PhotoGallery();
                obj.Title = model.Title;
             //   obj.TitleAr = model.TitleAr;
                obj.Featured = model.Featured;
                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/PhotoGallery/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.Photo = DfileName;
                }
                if (obj.Id == 0)
                {
                    context.PhotoGalleries.Add(obj);
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "Photogallery Added Successfully", ToastType.Success);
                    return RedirectToAction("AddEdit", new { id = obj.Id });
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Photogallery Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }
            AddToastMessage("Error", "Check Your from", ToastType.Error);
            return View(model);
        }
        public ActionResult Upload(int? id)
        {
            // if (this.CreateFolderIfNeeded(pathForSaving))

            var file = Request.Files["Filedata"];
            string savePath = Server.MapPath(@"~\Uploads\PhotoGallery\" + file.FileName);
            file.SaveAs(savePath);
            TempData["Delete"] = "Delete";
            var obj = context.PhotoGalleries.Find(id);

            var item = new PhotoGalleryItem
            {
                Image = file.FileName,
            };
            obj.PhotoGalleryItems.Add(item);
            context.SaveChanges();
            return Content(Url.Content(@"~\Uploads\PhotoGallery\" + file.FileName));
        }
        public ActionResult GetItemEditor()
        {
            return PartialView("~/Areas/Admin/Views/Shared/Editor/_AddEditItem.cshtml", new Item());
        }
        public ActionResult EditPhotoGallary(PhotoGalleryModel model)
        {
            PhotoGallery obj = context.PhotoGalleries.Where(p => p.Id == model.Id).FirstOrDefault();
            string Images = "";
            if (model.Items != null)
            {
                var addedItem = model.Items.Where(x => x.Id == null).ToList();

                var updated = (from dbItem in obj.PhotoGalleryItems
                               where model.Items.Any(e => e.Id == dbItem.Id)
                               select dbItem).ToList();


                var deleted = obj.PhotoGalleryItems.Except(updated).ToList();

                foreach (var item in addedItem)
                {
                    var photogalleryitem = new PhotoGalleryItem();
                    photogalleryitem.Description = item.Description;
                    photogalleryitem.DescriptionAr = item.DescriptionAr;
                    photogalleryitem.PhotoGalleryId = model.Id;
                    if (item.ItemImage != null && item.ItemImage.ContentLength > 0)
                    {
                        var Dstream = item.ItemImage.InputStream;
                        var DfileName = Path.GetFileName(item.ItemImage.FileName);
                        var DfilePath = string.Format("/Uploads/PhotoGallery/{0}", DfileName);
                        item.ItemImage.SaveAs(Server.MapPath(DfilePath));
                        photogalleryitem.Image = DfileName;
                    }
                    obj.PhotoGalleryItems.Add(photogalleryitem);
                }

                foreach (var item in updated)
                {
                    var modelItem = model.Items.SingleOrDefault(x => x.Id == item.Id);
                    if (modelItem != null)
                    {
                        item.Description = modelItem.Description;
                        item.DescriptionAr = modelItem.DescriptionAr;
                        if (modelItem.Photo == null)
                        {
                            if (modelItem.ItemImage != null && modelItem.ItemImage.ContentLength > 0)
                            {
                                var Dstream = modelItem.ItemImage.InputStream;
                                var DfileName = Path.GetFileName(modelItem.ItemImage.FileName);
                                var DfilePath = string.Format("/Uploads/PhotoGallery/{0}", DfileName);
                                modelItem.ItemImage.SaveAs(Server.MapPath(DfilePath));
                                item.Image = DfileName;
                            }

                        }
                    }

                }

                if (deleted != null)
                {
                    deleted.ForEach(item => context.PhotoGalleryItems.Remove(item));
                }
            }

            context.SaveChanges();
            AddToastMessage("Error", "Photogallery updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        private bool CreateFolderIfNeeded(string path)
        {
            bool result = true;
            if (!Directory.Exists(path))
            {
                try
                {
                    Directory.CreateDirectory(path);
                }
                catch (Exception)
                {
                    /*TODO: You must process this exception.*/
                    result = false;
                }
            }
            return result;
        }

        public ActionResult Delete(int id)
        {
            if (id != null)
            {
                try
                {
                    var gallery = context.PhotoGalleries.Where(p => p.Id == id).FirstOrDefault();
                    context.PhotoGalleries.Remove(gallery);
                    context.SaveChanges();
                    AddToastMessage("Error", "gallery removed successfully", ToastType.Error);
                    return RedirectToAction("/Index");
                }
                catch
                {
                    AddToastMessage("Error", "gallery removed successfully", ToastType.Error);
                    return RedirectToAction("/Index");
                }

            }
            AddToastMessage("Error", "cannot remove as this page is parent ", ToastType.Error);
            return RedirectToAction("/Index");
        }
    }
}