﻿using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class PagesMangementController : BaseController
    {
        public ActionResult Index(int? Id)
        {
            PageModel model = new PageModel();
            model.Id = Id;
            AdminSetting(model);
            return View(model);
        }
        public JsonResult GetPages(int? id)
        {
            var pagesList = from pages in context.Pages
                            where (id.HasValue ? pages.ParentId == id : pages.ParentId == null)
                            select new
                            {
                                id = pages.Id,
                                Title = pages.Title,
                                
                                hasChildren = pages.Page1.Any()
                            };

            return Json(pagesList, JsonRequestBehavior.AllowGet);
        }

        public List<Page> GetAllChield(int? ParentId, List<Page> listChield)
        {
            var listall = context.Pages.Where(f => f.ParentId == ParentId).ToList();
            if (listall.Count != 0)
            {
                listChield.AddRange(listall);
                foreach (var item in listall)
                {
                    GetAllChield(item.Id, listChield);
                }
            }
            return listChield;
        }

        [HttpPost]
        public ActionResult AddEditAr(int? Id, PageModel model)
        {
            
            Page obj = context.Pages.Where(p => p.Id ==Id).FirstOrDefault();
            if (obj != null)
            {
                obj.TitleAr = model.TitleAr;
                obj.ContentAr = model.ContentAr;
            }

            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public JsonResult GetPageData(int? Id)
        {
            PageModel model = new PageModel();
            var item = context.Pages.FirstOrDefault(f => f.Id == Id);
            model.Id = item.Id;
            model.ParentId = item.ParentId;
            model.Title = item.Title;
            model.TitleAr = item.TitleAr;
            model.OnMenu = item.OnMenu;
            model.Content = item.Content;
            model.Content = HttpUtility.HtmlDecode(item.Content);
            model.ContentAr = item.ContentAr;
            model.Order = item.Order;
            model.MetaTitle = item.Title;
            model.MetaDescription = item.MetaDescription;
            model.MetaKeyword = item.MetaKeyword;
            Setting obj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.ENCompanyName = obj.EnCompanyName;
            ModelState.Clear();
            return Json(model, JsonRequestBehavior.AllowGet);

        }

        public ActionResult Edit(PageModel model, int? Id)
        {
            var item = context.Pages.FirstOrDefault(f => f.Id == Id);
            model.Id = Id;
            AdminSetting(model);
            if (ModelState.IsValid)
            {
                if (item == null)
                {
                    item = new Page();

                    item.ParentId = model.ParentId;
                }
                item.Title = model.Title;
                item.TitleAr = model.TitleAr;
                item.OnMenu = model.OnMenu;
                item.Content = HttpUtility.HtmlDecode(model.Content);
                //var z = HttpUtility.HtmlEncode(model.Content);
                //var p = HttpUtility.HtmlEncode(z);

                var x= HttpUtility.HtmlDecode(model.Content);
                var y = HttpUtility.HtmlDecode(x);

                item.ContentAr = model.ContentAr;
                item.Order = model.Order;
                item.MetaTitle = model.MetaTitle;
                item.MetaDescription = model.MetaDescription;
                item.MetaKeyword = model.MetaKeyword;
                if (item.Id == 0)
                {
                    context.Pages.Add(item);
                    this.AddToastMessage("Success", "Page Added Successfully", ToastType.Success);
                }
                context.SaveChanges();
                ModelState.Clear();
                this.AddToastMessage("Success", "Page Edited Successfully", ToastType.Success);
                return RedirectToAction("Index", new { id = item.Id });

            }

            //If we got this far, something failed, redisplay form
            return RedirectToAction("Index");

        }

        public JsonResult Delete(int id)
        {
            if (id != -1)
            {
                var obj = context.Pages.SingleOrDefault(f => f.Id == id);
                var List = GetAllChield(id, new List<Page>()).OrderByDescending(c => c.Id).ToList();
                foreach (var item in List)
                {
                    context.Pages.Remove(item);
                    context.SaveChanges();
                }
                context.Pages.Remove(obj);
                context.SaveChanges();
                return Json(id, JsonRequestBehavior.AllowGet);
            }
            else
            {
                return Json("Error", JsonRequestBehavior.AllowGet);
            }
        }
    }
}