﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Helpers.Notification;


namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class PageMangementController : BaseController
    {
        public ActionResult Index()
        {
            var pages = context.Pages.OrderBy(p => p.Order).ToList();
           
            
            return View(pages);
        }

        //public ActionResult AddEdit(int? Id)
        //{
        //    PageModel model = new PageModel();
        //    ViewBag.Langs = context.Pages.ToList();
        //    if (Id.HasValue && Id.Value > 0)
        //    {
        //        model = context.Pages.Where(p => p.Id == Id.Value).Select(p => new PageModel
        //        {
        //            Id = p.Id,
        //            Title = p.Title,
        //            TitleAr = p.TitleAr,
        //            Content = p.Content,
        //            ContentAr = p.ContentAr,
        //            Order = p.Order,
        //            OnMenu = p.OnMenu,
        //            MetaTitle = p.MetaTitle,
        //            MetaDescription = p.MetaDescription,
        //            MetaKeyword = p.MetaKeyword,
        //            ParentId = p.ParentId
        //        }).FirstOrDefault();

        //    }
        //    else
        //    {
        //        model = new PageModel();
        //    }
        //    LoadLookups(model);
        //    return View(model);
        //}
        //[HttpPost]
        //public ActionResult AddEdit(PageModel model)
        //{
        //    if (ModelState.IsValid)
        //    {
        //        Page obj = null;
        //        if (model.Id > 0)
        //        {
        //            obj = context.Pages.Where(p => p.Id == model.Id).FirstOrDefault();
        //        }
        //        else
        //            obj = new Page();
        //        obj.Title = model.Title;
        //        obj.TitleAr = model.TitleAr;
        //        obj.Content = model.Content;
        //        obj.ContentAr = model.ContentAr;
        //        if (model.ParentId.HasValue)
        //            obj.ParentId = model.ParentId;
        //        obj.Order = model.Order;
        //        obj.OnMenu = model.OnMenu;
        //        obj.MetaTitle = model.MetaTitle;
        //        obj.MetaDescription = model.MetaDescription;
        //        obj.MetaKeyword = model.MetaKeyword;

        //        if (obj.Id == 0)
        //        {
        //            context.Pages.Add(obj);
        //            context.SaveChanges();
        //            this.AddToastMessage("Success", "Page Added Successfully", ToastType.Success);
        //        }
        //        else
        //        {
        //            context.SaveChanges();
        //            this.AddToastMessage("Success", "Page Edited Successfully", ToastType.Success);
        //        }

        //        return RedirectToAction("/Index");
        //    }
        //    AddToastMessage("Error", "Check Your from", ToastType.Error);
        //    LoadLookups(model);

        //    return View(model);
        //}
        public ActionResult Delete(int id)
        {
            if (id != null)
            {
                try
                {
                    var page = context.Pages.Where(p => p.Id == id).FirstOrDefault();
                    if (page.Page1.Count() > 0)
                    {
                        AddToastMessage("Error", "cannot remove as this page is parent ", ToastType.Error);
                        return RedirectToAction("/Index");
                    }
                    context.Pages.Remove(page);
                    context.SaveChanges();
                    AddToastMessage("Error", "page removed successfully", ToastType.Error);
                    return RedirectToAction("/Index");
                }
                catch
                {
                    AddToastMessage("Error", "cannot remove as this page is parent ", ToastType.Error);
                }

            }
            AddToastMessage("Error", "cannot remove as this page is parent ", ToastType.Error);
            return RedirectToAction("/Index");
        }
        private void LoadLookups(PageModel model)
        {

            var langs = from c in context.Pages
                        .Where(p =>(!model.Id.HasValue || p.Id != model.Id)).ToList()
                        select new BaseObject() { Id = c.Id, Name = c.Title };
            model.PagesList = new List<BaseObject>();
            model.PagesList.Add(new BaseObject() { Id = null, Name = "Select Parent" });
            model.PagesList.AddRange(langs.ToList());

        }

        public ActionResult GetPages()
        {
            if (Request.IsAjaxRequest())
            {
                var pages = context.Pages.OrderBy(p => p.Order).ToList();
                return PartialView("_Get", pages);
            }
            else
            {
                return View();
            }
        }

        public ActionResult AddEdit(int? Id)
        {
            PageModel model = new PageModel();
            Setting obj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.ENCompanyName = obj.EnCompanyName;
            ViewBag.Langs = context.Pages.ToList();
            if (Id.HasValue && Id.Value > 0)
            {
                model = context.Pages.Where(p => p.Id == Id.Value).Select(p => new PageModel
                {
                    Id = p.Id,
                    Title = p.Title,
                    TitleAr = p.TitleAr,
                    Content = p.Content,
                    ContentAr = p.ContentAr,
                    Order = p.Order,
                    OnMenu = p.OnMenu,
                    MetaTitle = p.MetaTitle,
                    MetaDescription = p.MetaDescription,
                    MetaKeyword = p.MetaKeyword,
                    ParentId = p.ParentId
                }).FirstOrDefault();

            }
            else
            {
                model = new PageModel();
            }
            LoadLookups(model);
            return PartialView("_AddEdit",model);
        }

        [HttpPost]
        public ActionResult Create(PageModel model)
        {
            if (ModelState.IsValid)
            {
                try
                {

                    Page obj = null;
                    if (model.Id > 0)
                    {
                        obj = context.Pages.Where(p => p.Id == model.Id).FirstOrDefault();
                    }
                    else
                        obj = new Page();
                    obj.Title = model.Title;
                    obj.TitleAr = model.TitleAr;
                    obj.Content = model.Content;
                    obj.ContentAr = model.ContentAr;
                    if (model.ParentId.HasValue)
                        obj.ParentId = model.ParentId;
                    obj.Order = model.Order;
                    obj.OnMenu = model.OnMenu;
                    obj.MetaTitle = model.MetaTitle;
                    obj.MetaDescription = model.MetaDescription;
                    obj.MetaKeyword = model.MetaKeyword;

                    if (obj.Id == 0)
                    {
                        context.Pages.Add(obj);
                        context.SaveChanges();
                        this.AddToastMessage("Success", "Page Added Successfully", ToastType.Success);
                    }
                    else
                    {
                        context.SaveChanges();
                        this.AddToastMessage("Success", "Page Edited Successfully", ToastType.Success);
                    }
                    Setting seobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
                    model.ENCompanyName = seobj.EnCompanyName;
                    return Json(new { success = true });
                }
                catch (Exception e)
                {
                    ModelState.AddModelError("", e.Message);
                }

            }
            //Something bad happened
            return PartialView("_AddEdit", model);
        }
    }
}