﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using NahrCms.Web.Helpers.Notification;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class NewsMangementController : BaseController
    {
        public ActionResult Index()
        {
            NewsModel model = new NewsModel();
            AdminSetting(model);
            return View(model);
        }

        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.News.OrderByDescending(x=>x.Date).Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower()))).Select(p => new NewsModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title,
                                                         Date=p.Date,
                                                         pageTitle = p.PageTitle
                                                     });
            var count = query.Count();
            List<NewsModel> list = new List<NewsModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Date ASC"))
            {
                list = query.OrderBy(item => item.Date).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Date DESC"))
            {
                list = query.OrderByDescending(item => item.Date).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }

        [HttpPost]
        public ActionResult AddEditFr(NewsModel model)
        {
            New obj = context.News.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleFr = model.TitleFr;
            obj.DescriptionFr = model.DescriptionFr;


            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEditNl(NewsModel model)
        {
            New obj = context.News.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleNl = model.TitleNl;
            obj.DescriptionNl = model.DescriptionNl;
             
            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult AddEdit(int? id)
        {
            NewsModel model = new NewsModel();
            
            if (id.HasValue && id.Value > 0)
            {
                New p = context.News.Where(d => d.Id == id).FirstOrDefault();
                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleFr = p.TitleFr;
                model.TitleNl = p.TitleNl;
                model.Description = p.Description;
                model.DescriptionFr = p.DescriptionFr;
                model.DescriptionNl = p.DescriptionNl;
                //model.Date = p.Date;
                model.MainPhoto = p.Image;
                model.PhotoGalleryId = p.PhotoGalleryId;
                model.Featured = p.Featured.Value;
            }
            else
            {
                model = new NewsModel();
                var date = DateTime.Now;
                model.Date = date.Date;
            }
            AdminSetting(model);
            LoadLookups(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult AddEdit(NewsModel model, IEnumerable<HttpPostedFileBase> files)
        {
            if (ModelState.IsValid)
            {

                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.MainPhoto))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);
                        LoadLookups(model);
                        return View(model);
                    }

                }

                New obj = null;
                var path = "";
                if (model.Id > 0)
                {
                    obj = context.News.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new New();
                obj.Title = model.Title;
                 obj.TitleFr = model.TitleFr;
                 obj.TitleNl = model.TitleNl;
                obj.Description = model.Description;
                 obj.DescriptionFr = model.DescriptionFr;
                 obj.DescriptionNl = model.DescriptionNl;
                obj.Featured = model.Featured;
                if (model.PhotoGalleryId.HasValue)
                    obj.PhotoGalleryId = model.PhotoGalleryId;
                obj.Date = DateTime.Now;

                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/News/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.Image = DfileName;
                }
                if (obj.Id == 0)
                {
                    context.News.Add(obj);
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "News Added Successfully", ToastType.Success);
                    return RedirectToAction("/Index");
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "News Edited Successfully", ToastType.Success);
                }
                //return RedirectToAction("AddEdit", new { id = obj.Id });
                return RedirectToAction("/Index");
            }
            LoadLookups(model);
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                    AddToastMessage("Error", modelError.ErrorMessage, ToastType.Error);
                }
            }
            if (model.MainImage == null)
            {
                if (String.IsNullOrEmpty(model.MainPhoto))
                {
                    AddToastMessage("Error", "Image are required", ToastType.Error);
                    modelErrors.Add("Image are required");
                }
            }
            return View(model);
        }

        public ActionResult Delete(int id)
        {
            var obj = context.News.Find(id);
            context.News.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }

        private void LoadLookups(NewsModel model)
        {
            var Photogallery = from c in context.PhotoGalleries.ToList()
                                         select new BaseObject() { Id = c.Id, Name = c.Title };
            model.PhotoGalleryList = new List<BaseObject>();
            model.PhotoGalleryList.Add(new BaseObject() { Id = null, Name = "Select PhotoGallery" });
            model.PhotoGalleryList.AddRange(Photogallery.ToList());

        }
    }
}