﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Settings;
using NahrCms.Web.Areas.admin.DataModels.Models.ShowRooms;
using NahrCms.Web.Helpers.Notification;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class MobileSettingController : BaseController
    {
        // GET: admin/MobileSetting
        public ActionResult Index()
        {
            MobileSettingModel model = new MobileSettingModel();
            AdminSetting(model);

            return View(model);
        }

        [HttpPost]
        public JsonResult Search(string DayName, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.DaySettings.Where(p => (string.IsNullOrEmpty(DayName)
                                                     || p.DayName.ToLower().Contains(DayName.ToLower())
                                                     )).Select(p => new MobileSettingModel
                                                     {
                                                         Id = p.Id,
                                                         DayName = p.DayName,
                                                     });
            var count = query.Count();
            List<MobileSettingModel> list = new List<MobileSettingModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("DayName ASC"))
            {
                list = query.OrderBy(item => item.DayName).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("DayName DESC"))
            {
                list = query.OrderByDescending(item => item.DayName).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
           


            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }


        public ActionResult Edit(int? id)
        {
            MobileSettingModel model = new MobileSettingModel();

            if (id.HasValue && id.Value > 0)
            {
                
                DaySetting p = context.DaySettings.Where(d => d.Id == id).FirstOrDefault();
                model.Id = p.Id;
                model.DayName = p.DayName;
                if (p.OpenAt != null)
                    model.OpenAt = p.OpenAt.Value;
                if (p.CloseAt != null)
                    model.CloseAt = p.CloseAt.Value;
                model.working = p.working.Value;
            }
            AdminSetting(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult Edit(MobileSettingModel model)
        {

            if (ModelState.IsValid)
            {

                DaySetting obj =context.DaySettings.Where(p => p.Id == model.Id).FirstOrDefault();
               
               
                obj.working = model.working;
                obj.OpenAt = model.OpenAt;
                obj.CloseAt = model.CloseAt;
              


              
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Day Edited Successfully", ToastType.Success);
                    return RedirectToAction("/Index");
                }
            
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                }
            }
            AddToastMessage("Error", string.Join("<br />", modelErrors.ToArray()), ToastType.Error);
            return View(model);
        }
    }
}