﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Models.Materials;
using NahrCms.Web.Helpers.Notification;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Mvc;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class MaterialMangementController : BaseController
    {
        // GET: admin/MaterialMangement
        public ActionResult Index()
        {
            MaterialModel model = new MaterialModel();
            AdminSetting(model);
            return View(model);
        }

        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.Materials.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower()))).Select(p => new MaterialModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title,
                                                         
                                                     });
            var count = query.Count();
            List<MaterialModel> list = new List<MaterialModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
           

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }

        [HttpPost]
        public ActionResult AddEditAr(MaterialModel model)
        {
            Material obj = context.Materials.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleAr = model.TitleAr;
            obj.DescriptionAr = model.DescriptionAr;


            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult AddEdit(int? id)
        {
            MaterialModel model = new MaterialModel();
          
            if (id.HasValue && id.Value > 0)
            {
                Material p = context.Materials.Where(d => d.Id == id).FirstOrDefault();
                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleAr = p.TitleAr;
                model.Description = p.Description;
                model.DescriptionAr = p.DescriptionAr;
                model.MainPhoto = p.Image;
                model.ProductId = p.ProductId;
                if (p.PhotoGallery != null)
                    model.PhotosUpload = p.PhotoGallery.Split(',').ToList();
                LoadLookups(model);
                AdminSetting(model);
                return View(model);
            }
            else
            {
                model = new MaterialModel();
                LoadLookups(model);
                AdminSetting(model);
                return View(model);
            }
           
        }
         [HttpPost]
        public ActionResult AddEdit(MaterialModel model, IEnumerable<HttpPostedFileBase> files, string[] SelectedProducts)
        {
            var relatedProducts = context.Products.ToList();
            if (ModelState.IsValid)
            {

                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.MainPhoto))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);
                        LoadLookups(model);
                        return View(model);
                    }

                }

                Material obj = null;
                var path = "";
                if (model.Id > 0)
                {
                    obj = context.Materials.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new Material();
                obj.Title = model.Title;
               // obj.TitleAr = model.TitleAr;
                obj.Description = model.Description;
               // obj.DescriptionAr = model.DescriptionAr;
                obj.Color = model.Color;
                obj.Type = model.Type;
                
               
                if (model.ProductId.HasValue)
                    obj.ProductId = model.ProductId;

                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/Material/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.Image = DfileName;
                }
                if (obj.Id == 0)
                {
                    context.Materials.Add(obj);
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "Material Added Successfully", ToastType.Success);
                    return RedirectToAction("AddEdit", new { id = obj.Id });
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Material Edited Successfully", ToastType.Success);
                }

                //return RedirectToAction("AddEdit", new { id = obj.Id });
                return RedirectToAction("/Index");
            }

            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                }
            }
            AddToastMessage("Error", string.Join("<br />", modelErrors.ToArray()), ToastType.Error);
            LoadLookups(model);
            return View(model);
        }
        [HttpPost]
         public ActionResult EditPhotoGallary(MaterialModel model, IEnumerable<HttpPostedFileBase> files)
        {
            Material obj = context.Materials.Where(p => p.Id == model.Id).FirstOrDefault();
            Setting seobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.ENCompanyName = seobj.EnCompanyName;
            string Images = "";
            if (files != null)
            {
                foreach (HttpPostedFileBase file in files)
                {
                    var fileName = Path.GetFileName(file.FileName);
                    var filePath = string.Format("/Uploads/Material/{0}", fileName);
                    file.SaveAs(Server.MapPath(filePath));
                    if (Images == "")
                    {
                        Images = fileName;
                    }
                    else
                    {
                        Images = Images + "," + fileName;
                    }
                }
            }
            if (obj.PhotoGallery == null || obj.PhotoGallery == "")
                obj.PhotoGallery = Images;
            else
                obj.PhotoGallery = obj.PhotoGallery + "," + Images;

            context.SaveChanges();
            AddToastMessage("Error", "Material updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult Delete(int id)
        {
            var obj = context.Products.Find(id);
            context.Products.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
        public ActionResult DeletePhoto(int Id, int Index)
        {
            var obj = context.Products.SingleOrDefault(f => f.Id == Id);
            var Photos = obj.PhotoGallery.Split(',').ToList();
            Photos.RemoveAt(Index);
            string Images = "";
            foreach (var item in Photos)
            {
                if (Images == "")
                {
                    Images = item;
                }
                else
                {
                    Images = Images + "," + item;
                }
            }
            obj.PhotoGallery = Images;
            context.SaveChanges();
            TempData["Delete"] = "Delete";
            return RedirectToAction("AddEdit", "MaterialMangement", new { Id = Id });
        }
        static string ConvertStringArrayToString(string[] array)
        {
            //
            // Concatenate all the elements into a StringBuilder.
            //
            StringBuilder builder = new StringBuilder();
            foreach (string value in array)
            {
                if (value != "")
                    builder.Append(value);
                builder.Append(',');
            }
            return builder.ToString();
        }
        private void LoadLookups(MaterialModel model)
        {
            var relatedProduct = from c in context.Products.ToList()
                                         select new BaseObject() { Id = c.Id, Name = c.Title };
            model.ProductList = new List<BaseObject>();
            model.ProductList.Add(new BaseObject() { Id = -1, Name = "Select Product" });
            model.ProductList.AddRange(relatedProduct.ToList());

        }
    }
}