﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Career;
using NahrCms.Web.Helpers.Notification;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class JobMangementController : BaseController
    {
        public ActionResult Index()
        {
            JobModel model = new JobModel();
            AdminSetting(model);
            return View(model);
        }

        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.Jobs.OrderByDescending(x => x.CreatedOn).Where(p => (string.IsNullOrEmpty(Title)
                                                       || p.TitleEn.ToLower().Contains(Title.ToLower()))).Select(p => new JobModel
                                                       {
                                                           Id = p.Id,
                                                           TitleEn = p.TitleEn,
                                                           TitleFr = p.TitleFr,
                                                           TitleNl = p.TitleNl,
                                                           CreatedOn = p.CreatedOn
                                                       });
            var count = query.Count();
            List<JobModel> list = new List<JobModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.TitleEn).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.TitleEn).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Date ASC"))
            {
                list = query.OrderBy(item => item.CreatedOn).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Date DESC"))
            {
                list = query.OrderByDescending(item => item.CreatedOn).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }
        [HttpPost]
        public ActionResult AddEditFr(JobModel model)
        {
            Job obj = context.Jobs.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleFr = model.TitleFr;
            obj.DescriptionFr = model.DescriptionFr;

            context.SaveChanges();
            AddToastMessage("Success", "Job updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEditNl(JobModel model)
        {
            Job obj = context.Jobs.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleNl = model.TitleNl;
            obj.DescriptionNl = model.DescriptionNl;

            context.SaveChanges();
            AddToastMessage("Success", "Job updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult AddEdit(int? id)
        {
            JobModel model = new JobModel();

            if (id.HasValue && id.Value > 0)
            {
                Job p = context.Jobs.Where(d => d.Id == id).FirstOrDefault();
                model.Id = p.Id;
                model.TitleEn = p.TitleEn;
                model.TitleFr = p.TitleFr;
                model.TitleNl = p.TitleNl;
                model.DescriptionEn = p.DescriptionEn;
                model.DescriptionFr = p.DescriptionFr;
                model.DescriptionNl = p.DescriptionNl;
            }
            else
            {
                model = new JobModel();
                var date = DateTime.Now;
                model.CreatedOn = date.Date;
            }
            AdminSetting(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult AddEdit(JobModel model, IEnumerable<HttpPostedFileBase> files)
        {
            if (ModelState.IsValid)
            {

                Job obj = null;
                var path = "";
                if (model.Id > 0)
                {
                    obj = context.Jobs.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new Job();
                obj.TitleEn = model.TitleEn;
                obj.TitleFr = model.TitleFr;
                obj.TitleNl = model.TitleNl;
                obj.DescriptionEn = model.DescriptionEn;
                obj.DescriptionFr = model.DescriptionFr;
                obj.DescriptionNl = model.DescriptionNl;
                obj.CreatedOn = DateTime.Now;

                if (obj.Id == 0)
                {
                    context.Jobs.Add(obj);
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "job Added Successfully", ToastType.Success);
                    return RedirectToAction("/Index");
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "job Edited Successfully", ToastType.Success);
                }
                //return RedirectToAction("AddEdit", new { id = obj.Id });
                return RedirectToAction("/Index");
            }
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                    AddToastMessage("Error", modelError.ErrorMessage, ToastType.Error);
                }
            }
            return View(model);
        }

        public ActionResult Delete(int id)
        {
            var obj = context.Jobs.Find(id);
            context.Jobs.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }

    }
}