﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class EventMangementController : BaseController
    {
        public ActionResult Index()
        {
            EventModel model = new EventModel();
            AdminSetting(model);
            LoadLookups(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Title, int? EventCategoryId, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            //context.Configuration.ProxyCreationEnabled = false;
            var query = context.Events.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower())
                                                     ))
                                                     .Where(p =>
                                                     (!EventCategoryId.HasValue || p.EventCategory.Id == EventCategoryId))
                                                     .Select(p => new EventModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title,
                                                         //ProjectCategory = p.ProjectCategory.Title
                                                     });
            var count = query.Count();
            List<EventModel> list = new List<EventModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            //else if (jtSorting.Equals("ProjectCategory ASC"))
            //{
            //    list = query.OrderBy(item => item.ProjectCategory).Skip(jtStartIndex).Take(jtPageSize).ToList();
            //}

            //else if (jtSorting.Equals("ProjectCategory DESC"))
            //{
            //    list = query.OrderByDescending(item => item.ProjectCategory).Skip(jtStartIndex).Take(jtPageSize).ToList();
            //}

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }
        [HttpPost]
        public ActionResult AddEditAr(EventModel model)
        {
            Event obj = context.Events.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleAr = model.TitleAr;
            obj.DescriptionAr = model.DescriptionAr;
           

            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult AddEdit(int? id)
        {
            EventModel model = new EventModel();
           
            if (id.HasValue && id.Value > 0)
            {
                Event p = context.Events.Where(d => d.Id == id).FirstOrDefault();
                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleAr = p.TitleAr;
                model.Description = p.Description;
                model.DescriptionAr = p.DescriptionAr;
                model.MainPhoto = p.Image;
                model.EventCategoryId = p.EventCategoryId;
                model.PhotoGalleryId = p.PhotoGalleryId;
                model.Date = p.Date.Value;
                
            }
            else
            {
                model = new EventModel();
               
                var date = DateTime.Now;
                model.Date = date.Date;
            }
            AdminSetting(model);
            LoadLookups(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult AddEdit(EventModel model, IEnumerable<HttpPostedFileBase> files)
        {
            var relatedProjects = context.Projects.ToList();
            if (ModelState.IsValid)
            {

                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.MainPhoto))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);

                        LoadLookups(model);
                        return View(model);
                    }

                }

                Event obj = null;
                var path = "";
                if (model.Id > 0)
                {
                    obj = context.Events.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new Event();
                obj.Title = model.Title;
               // obj.TitleAr = model.TitleAr;
                obj.Description = model.Description;
              //  obj.DescriptionAr = model.DescriptionAr;
                if (model.PhotoGalleryId.HasValue)
                    obj.PhotoGalleryId = model.PhotoGalleryId;
                obj.EventCategoryId = model.EventCategoryId;
                obj.Date = model.Date;
                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/Event/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.Image = DfileName;
                }
                if (obj.Id == 0)
                {
                    context.Events.Add(obj);
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "Event Added Successfully", ToastType.Success);
                    return RedirectToAction("/Index");
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Event Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }

            LoadLookups(model);
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                    AddToastMessage("Error", modelError.ErrorMessage, ToastType.Error);
                }
            }
            if (model.MainImage == null)
            {
                if (String.IsNullOrEmpty(model.MainPhoto))
                {
                    AddToastMessage("Error", "Image are required", ToastType.Error);
                    modelErrors.Add("Image are required");
                }
            }
            return View(model);
        }

        public ActionResult Delete(int id)
        {
            var obj = context.Events.Find(id);
            context.Events.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }

        private void LoadLookups(EventModel model)
        {
            var PhotoGalley = from c in context.PhotoGalleries.ToList()
                              select new BaseObject() { Id = c.Id, Name = c.Title };
            model.PhotoGalleryList = new List<BaseObject>();
            model.PhotoGalleryList.Add(new BaseObject() { Id = null, Name = "Select PhotoGallery" });
            model.PhotoGalleryList.AddRange(PhotoGalley.ToList());

            var EventCategory = from c in context.EventCategories.ToList()
                                select new BaseObject() { Id = c.Id, Name = c.Title };
            model.EventCategoryList = new List<BaseObject>();
            model.EventCategoryList.Add(new BaseObject() { Id = null, Name = "Select Event Category" });
            model.EventCategoryList.AddRange(EventCategory.ToList());
        }
    }
}