﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class EventCategoryMangementController : BaseController
    {
        public ActionResult Index()
        {
            EventCategoryModel model = new EventCategoryModel();
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.EventCategories.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower()))).
                                                     Select(p => new EventCategoryModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title
                                                     }); ;
            var count = query.Count();
            List<EventCategoryModel> list = new List<EventCategoryModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count });
        }

        [HttpPost]
        public ActionResult AddEditAr(EventCategoryModel model)
        {
            EventCategory obj = context.EventCategories.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleAr = model.TitleAr;


            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult AddEdit(int? Id)
        {
            EventCategoryModel model = new EventCategoryModel();
            AdminSetting(model);
            if (Id.HasValue && Id.Value > 0)
            {
                EventCategory p = context.EventCategories.Where(x => x.Id == Id.Value).FirstOrDefault();

                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleAr = p.TitleAr;
                model.Color = p.Color;


            }

            return View(model);
        }
        [HttpPost]
        public ActionResult AddEdit(EventCategoryModel model)
        {
            if (ModelState.IsValid)
            {
                EventCategory obj = null;
                if (model.Id > 0)
                {
                    obj = context.EventCategories.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new EventCategory();
                obj.Title = model.Title;
                // obj.TitleAr = model.TitleAr;
                obj.Color = model.Color;
                if (obj.Id == 0)
                {
                    context.EventCategories.Add(obj);
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Event Category Added Successfully", ToastType.Success);
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Event Category Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                    AddToastMessage("Error", modelError.ErrorMessage, ToastType.Error);
                }
            }
            AdminSetting(model);
            return View(model);
        }
        public ActionResult Delete(int id)
        {
            var obj = context.EventCategories.Find(id);
            context.EventCategories.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
    }
}