﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Career;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class CareerController : BaseController
    {
        public ActionResult Index()
        {
            CareerModel model = new CareerModel();
            AdminSetting(model);
            return View(model);
        }
        public ActionResult AddEdit(int? Id)
        {
            CareerModel model = new CareerModel();
            AdminSetting(model);
            if (Id.HasValue && Id.Value > 0)
            {
                Career p = context.Careers.Where(x => x.Id == Id.Value).FirstOrDefault();

                model.Id = p.Id;
                //model.DepartmentName = p.Department.Value==1? "Sales and marketing":
                //    p.Department.Value == 2 ? "Purchasing" :
                //    p.Department.Value == 3 ? "Accounting and finance" : "Hr";
               // model.GenderName = p.Gender.Value == 1 ? "Male" : "Female";
                model.Name = p.Name;
                model.Position = p.Position;
                model.Gender = p.Gender;
                model.Department = p.Department;
                model.Email = p.Email;
                model.Comment = p.Comment;
                model.CVPath = p.cvpath;
                model.JobTitle = context.Jobs.Where(c => c.Id == p.JobId).Select(c => c.TitleEn).FirstOrDefault();
                
            }

            return View(model);
        }
        [HttpPost]
        public ActionResult AddEdit(CareerModel model)
        {
            if (ModelState.IsValid)
            {
                Career obj = null;
                if (model.Id > 0)
                {
                    obj = context.Careers.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new Career();
              //  obj.Department = model.DepartmentId;
                //obj.Gender = model.GenderId;
                obj.Name = model.Name;
                obj.Position = model.Position;
                model.Gender = model.Gender;
                model.Department = model.Department;
                obj.Email = model.Email;
                obj.Comment = model.Comment;
                obj.cvpath = model.CVPath;

                if (obj.Id == 0)
                {
                    context.Careers.Add(obj);
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Event Category Added Successfully", ToastType.Success);
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Event Category Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                    AddToastMessage("Error", modelError.ErrorMessage, ToastType.Error);
                }
            }
            AdminSetting(model);
            return View(model);
        }
        public ActionResult Delete(int id)
        {
            var obj = context.Careers.Find(id);
            context.Careers.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
        [HttpPost]
        public JsonResult Search(string Name, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.Careers.Where(p => (string.IsNullOrEmpty(Name)
                                                     || p.Name.ToLower().Contains(Name.ToLower()))).
                                                     Select(p => new CareerModel
                                                     {
                                                         Id = p.Id,
                                                         Name = p.Name,
                                                         JobTitle = context.Jobs.Where(c => c.Id == p.JobId).Select(c => c.TitleEn).FirstOrDefault()
                                                     });
            var count = query.Count();
            List<CareerModel> list = new List<CareerModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Name).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Name).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count });
        }

        [HttpPost]
        public ActionResult AddEditAr(CareerModel model)
        {
            Career obj = context.Careers.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.Name = model.Name;


            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public virtual FileResult Downloadpdf(string file)
        {
            string filepath = Server.MapPath("~/Uploads/CV/"+file);
            byte[] pdfByte = GetBytesFromFile(filepath);
            return File(pdfByte, "application/pdf", file);
        }
        public byte[] GetBytesFromFile(string fullFilePath)
        {
            // this method is limited to 2^32 byte files (4.2 GB)
            FileStream fs = null;
            try
            {
                fs = System.IO.File.OpenRead(fullFilePath);
                byte[] bytes = new byte[fs.Length];
                fs.Read(bytes, 0, Convert.ToInt32(fs.Length));
                return bytes;
            }
            finally
            {
                if (fs != null)
                {
                    fs.Close();
                    fs.Dispose();
                }
            }
        }

    }
}