﻿using System.Web.Mvc;
using System.Linq;
using NahrCms.DAL;

using NahrCms.Web.Helpers.Notification;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;
using Microsoft.AspNet.Identity;
using NahrCms.Web.Models;
using NahrCms.Web.Helpers;

namespace NahrCms.Web.Areas.admin.Controllers
{

    public abstract partial class BaseController : Controller
    {
        protected NahrCmsAppEntities context = new NahrCmsAppEntities();
        public Toastr Toastr { get; set; }
        /// <summary>
        /// On exception
        /// </summary>
        /// <param name="filterContext">Filter context</param>

        public BaseController()
        {
            Toastr = new Toastr();
        }
        public ToastMessage AddToastMessage(string title, string message, ToastType toastType)
        {
            return Toastr.AddToastMessage(title, message, toastType);
        }

        public void AdminSetting(BaseModel model)
        {
            Setting obj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();

            User.Identity.GetUserName();

            if (User.Identity.GetUserName() == "superadmin@admin.com")
                model.UserRole = "superadmin@admin.com";

            if (obj.AdminEvents != null)
                model.AdminMenuEvents = obj.AdminEvents.Value;
            if (obj.AdminProject != null)
                model.AdminMenuProjects = obj.AdminProject.Value;
            if (obj.AdminPhotoGallery != null)
                model.AdminMenuPhotoGalleries = obj.AdminPhotoGallery.Value;
            if (obj.AdminProduct != null)
                model.AdminMenuProducts = obj.AdminProduct.Value;
            if (obj.AdminMaterials != null)
                model.AdminMenuMaterials = obj.AdminMaterials.Value;
            if (obj.AdminShowRooms != null)
                model.AdminMenuShowRooms = obj.AdminShowRooms.Value;
            if (obj.AdminNews != null)
                model.AdminMenuNews = obj.AdminNews.Value;
            if (obj.ArabicLanguage != null)
                model.hasArabic = obj.ArabicLanguage.Value;
            if (obj.EnglishLanguage != null)
                model.hasEnglish = obj.EnglishLanguage.Value;
            if(obj.AdminMobileSetting != null )
                model.AdminMenuMobileSettings = obj.AdminMobileSetting.Value;
            model.ENCompanyName = obj.EnCompanyName;

        }

        protected override void OnActionExecuting(ActionExecutingContext filterContext)
        {
            int culture = 0;
            if (this.Session == null || this.Session["Culture"] == null)
            {
                int.TryParse(System.Configuration.ConfigurationManager.AppSettings["Culture"], out culture);
                this.Session["Culture"] = culture;
            }
            else
            {
                culture = (int)this.Session["Culture"];
            }
            // calling CultureHelper class properties for setting
            CultureHelper.CurrentCulture = (Lang)culture;

            base.OnActionExecuting(filterContext);
            //Your logic is here...
        }



    }
}